/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.protocols;

import java.io.EOFException;
import jpcsp.network.protocols.InternetChecksum;
import jpcsp.network.protocols.NetPacket;
import jpcsp.util.Utilities;

public class ICMP {
    public static final int ICMP_CONTROL_ECHO_REPLY = 0;
    public static final int ICMP_CONTROL_ECHO_REQUEST = 8;
    public int type;
    public int code;
    public int checksum;
    public int restOfHeader;
    public byte[] payload;

    public ICMP() {
    }

    public ICMP(ICMP icmp) {
        this.type = icmp.type;
        this.code = icmp.code;
        this.checksum = icmp.checksum;
        this.restOfHeader = icmp.restOfHeader;
        this.payload = icmp.payload;
    }

    public void read(NetPacket packet) throws EOFException {
        this.type = packet.read8();
        this.code = packet.read8();
        this.checksum = packet.read16();
        this.restOfHeader = packet.read32();
        this.payload = packet.readBytes(packet.getLength());
    }

    public NetPacket write(NetPacket packet) throws EOFException {
        packet.write8(this.type);
        packet.write8(this.code);
        packet.write16(this.checksum);
        packet.write32(this.restOfHeader);
        packet.writeBytes(this.payload);
        return packet;
    }

    public NetPacket write() throws EOFException {
        return this.write(new NetPacket(this.sizeOf()));
    }

    public void computeChecksum() throws EOFException {
        this.checksum = 0;
        NetPacket checksumPacket = this.write();
        this.checksum = InternetChecksum.computeInternetChecksum(checksumPacket.getBuffer(), 0, checksumPacket.getOffset());
    }

    public int sizeOf() {
        int size = 8;
        if (this.payload != null) {
            size += this.payload.length;
        }
        return size;
    }

    public String toString() {
        return String.format("type=0x%X, code=0x%X, checksum=0x%04X, restOfHeader=0x%08X, payload=%s", this.type, this.code, this.checksum, this.restOfHeader, Utilities.getMemoryDump(this.payload, 0, this.payload.length));
    }
}

